////----------------------------------------------------------------------------------
// File:        nvfourcc.h
// SDK Version: 1.0.2
//
// SPDX-FileCopyrightText: Copyright (c) 2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
// SPDX-License-Identifier: LicenseRef-NvidiaProprietary
//
// NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
// property and proprietary rights in and to this material, related
// documentation and any modifications thereto. Any use, reproduction,
// disclosure or distribution of this material and related documentation
// without an express license agreement from NVIDIA CORPORATION or
// its affiliates is strictly prohibited.
//
//----------------------------------------------------------------------------------

#ifndef _NVFOURCC_H_
#define _NVFOURCC_H_

#define MAX_FOURCC_CODES 64     // constant used to size arrays..

/* MMIO macros */
#ifndef mmioFOURCC
#define mmioFOURCC( ch0, ch1, ch2, ch3 )                                \
                ((DWORD)(BYTE)(ch0) | ((DWORD)(BYTE)(ch1) << 8) |   \
                ((DWORD)(BYTE)(ch2) << 16) | ((DWORD)(BYTE)(ch3) << 24 ))
#endif // mmioFOURCC

/* FOURCC video formats we support */
#ifndef FOURCC_UYVY
#define FOURCC_UYVY                        mmioFOURCC('U','Y','V','Y')
#endif
#ifndef FOURCC_YUY2
#define FOURCC_YUY2                        mmioFOURCC('Y','U','Y','2')
#endif
#ifndef FOURCC_YV12
#define FOURCC_YV12                        mmioFOURCC('Y','V','1','2')
#endif
#ifndef FOURCC_IYUV
#define FOURCC_IYUV                        mmioFOURCC('I','Y','U','V')
#endif
#ifndef FOURCC_YV16
#define FOURCC_YV16                        mmioFOURCC('Y','V','1','6')
#endif
#ifndef FOURCC_NVMC
#define FOURCC_NVMC                        mmioFOURCC('N','V','M','C')
#endif
#ifndef FOURCC_NVMP
#define FOURCC_NVMP                        mmioFOURCC('N','V','M','P')
#endif
#ifndef FOURCC_NVMD
#define FOURCC_NVMD                        mmioFOURCC('N','V','M','D')
#endif
#ifndef FOURCC_NVDP
#define FOURCC_NVDP                        mmioFOURCC('N','V','D','P')
#endif
#ifndef FOURCC_NV12
#define FOURCC_NV12                        mmioFOURCC('N','V','1','2')
#endif
#ifndef FOURCC_YYYY
#define FOURCC_YYYY                        mmioFOURCC('Y','Y','Y','Y')
#endif
#ifndef FOURCC_UVUV
#define FOURCC_UVUV                        mmioFOURCC('U','V','U','V')
#endif
#ifndef FOURCC_VVUU
#define FOURCC_VVUU                        mmioFOURCC('V','V','U','U')
#endif
#ifndef FOURCC_NVID
#define FOURCC_NVID                        mmioFOURCC('N','V','I','D')
#endif
#ifndef FOURCC_420i
#define FOURCC_420i                        mmioFOURCC('4','2','0','i')
#endif
#ifndef FOURCC_IF09
#define FOURCC_IF09                        mmioFOURCC('I','F','0','9')
#endif
#ifndef FOURCC_YVU9
#define FOURCC_YVU9                        mmioFOURCC('Y','V','U','9')
#endif
#ifndef FOURCC_IV32
#define FOURCC_IV32                        mmioFOURCC('I','V','3','2')
#endif
#ifndef FOURCC_IV31
#define FOURCC_IV31                        mmioFOURCC('I','V','3','1')
#endif
#ifndef FOURCC_RAW8
#define FOURCC_RAW8                        mmioFOURCC('R','A','W','8')
#endif
#ifndef FOURCC_UBAD
#define FOURCC_UBAD                        mmioFOURCC('U','B','A','D')
#endif
#ifndef FOURCC_NV24
#define FOURCC_NV24                        mmioFOURCC('N','V','2','4')
#endif
#ifndef FOURCC_TYUV                        // Ten bit YUV (TYUV) surface A(2bit) V(10bit) u(10bit) Y(10bit)
#define FOURCC_TYUV                        mmioFOURCC('T','Y','U','V')
#endif
#ifndef FOURCC_P010
#define FOURCC_P010                        mmioFOURCC('P','0','1','0')
#endif
#ifndef FOURCC_UV16
#define FOURCC_UV16                        mmioFOURCC('U','V','1','6')
#endif
#ifndef FOURCC_YY16
#define FOURCC_YY16                        mmioFOURCC('Y','Y','1','6')
#endif
#ifndef FOURCC_P016
#define FOURCC_P016                        mmioFOURCC('P','0','1','6')
#endif
#ifndef FOURCC_P210
#define FOURCC_P210                        mmioFOURCC('P','2','1','0')
#endif
#ifndef FOURCC_P216
#define FOURCC_P216                        mmioFOURCC('P','2','1','6')
#endif
/* FOURCC formats for subpicture */
#ifndef FOURCC_AI44
#define FOURCC_AI44                        mmioFOURCC('A','I','4','4')
#endif

#ifndef FOURCC_AI88
#define FOURCC_AI88                        mmioFOURCC('A','I','8','8')
#endif

#ifndef FOURCC_IA44
#define FOURCC_IA44                        mmioFOURCC('I','A','4','4')
#endif
#ifndef FOURCC_AYUV
#define FOURCC_AYUV                        mmioFOURCC('A','Y','U','V')
#endif
#ifndef FOURCC_AIP8
#define FOURCC_AIP8                        mmioFOURCC('A','I','P','8')      // 8 bit index into palette (bluray)
#endif
#ifndef FOURCC_PL16
#define FOURCC_PL16                        mmioFOURCC('P','L','1','6')      // internal palette for ai44
#endif
#ifndef FOURCC_PLFF
#define FOURCC_PLFF                        mmioFOURCC('P','L','F','F')      // palette for aip8
#endif
#ifndef FOURCC_AV12
#define FOURCC_AV12                        mmioFOURCC('A','V','1','2')      // nv12 data for alpha blend (bluray)
#endif

// floag
#ifndef FOURCC_FX32
#define FOURCC_FX32                        mmioFOURCC('F','X','3','2')
#endif

/* FOURCC formats we support for 3d textures */
#ifndef FOURCC_NVN0
#define FOURCC_NVN0                        mmioFOURCC('N','V','N','0')
#endif
#ifndef FOURCC_NVN1
#define FOURCC_NVN1                        mmioFOURCC('N','V','N','1')
#endif
#ifndef FOURCC_NVN2
#define FOURCC_NVN2                        mmioFOURCC('N','V','N','2')
#endif
#ifndef FOURCC_NVN3
#define FOURCC_NVN3                        mmioFOURCC('N','V','N','3')
#endif
#ifndef FOURCC_NVN4
#define FOURCC_NVN4                        mmioFOURCC('N','V','N','4')
#endif
#ifndef FOURCC_NVN5
#define FOURCC_NVN5                        mmioFOURCC('N','V','N','5')
#endif
#ifndef FOURCC_NVN6
#define FOURCC_NVN6                        mmioFOURCC('N','V','N','6')  // not used yet
#endif
#ifndef FOURCC_NVN7
#define FOURCC_NVN7                        mmioFOURCC('N','V','N','7')  // not used yet
#endif
#ifndef FOURCC_NVN8
#define FOURCC_NVN8                        mmioFOURCC('N','V','N','8')  // not used yet
#endif
#ifndef FOURCC_NVN9
#define FOURCC_NVN9                        mmioFOURCC('N','V','N','9')  // not used yet
#endif
#ifndef FOURCC_NVNn
#define FOURCC_NVNn                        mmioFOURCC('N','V','N', 0)
#endif
#ifndef FOURCC_NVN_MASK
#define FOURCC_NVN_MASK                    mmioFOURCC(0xff, 0xff, 0xff, 0)
#endif
#ifndef FOURCC_NVX0
#define FOURCC_NVX0                        mmioFOURCC('N','V','X','0')
#endif
#ifndef FOURCC_NVX1
#define FOURCC_NVX1                        mmioFOURCC('N','V','X','1')
#endif
#ifndef FOURCC_NVX2
#define FOURCC_NVX2                        mmioFOURCC('N','V','X','2')
#endif
#ifndef FOURCC_NVX3
#define FOURCC_NVX3                        mmioFOURCC('N','V','X','3')
#endif
#ifndef FOURCC_NVX4
#define FOURCC_NVX4                        mmioFOURCC('N','V','X','4')
#endif
#ifndef FOURCC_NVX5
#define FOURCC_NVX5                        mmioFOURCC('N','V','X','5')
#endif
#ifndef FOURCC_NVX6
#define FOURCC_NVX6                        mmioFOURCC('N','V','X','6')  // not used yet
#endif
#ifndef FOURCC_NVX7
#define FOURCC_NVX7                        mmioFOURCC('N','V','X','7')  // not used yet
#endif
#ifndef FOURCC_NVX8
#define FOURCC_NVX8                        mmioFOURCC('N','V','X','8')  // not used yet
#endif
#ifndef FOURCC_NVX9
#define FOURCC_NVX9                        mmioFOURCC('N','V','X','9')  // not used yet
#endif
#ifndef FOURCC_NVXn
#define FOURCC_NVXn                        mmioFOURCC('N','V','X', 0)
#endif
#ifndef FOURCC_NVX_MASK
#define FOURCC_NVX_MASK                    mmioFOURCC(0xff, 0xff, 0xff, 0)
#endif
#ifndef FOURCC_NVHU
#define FOURCC_NVHU                        mmioFOURCC('N','V','H','U')
#endif
#ifndef FOURCC_NVHS
#define FOURCC_NVHS                        mmioFOURCC('N','V','H','S')
#endif
#ifndef FOURCC_NVBB
#define FOURCC_NVBB                        mmioFOURCC('N','V','B','B')
#endif
#ifndef FOURCC_NVFB
#define FOURCC_NVFB                        mmioFOURCC('N','V','F','B')
#endif
#ifndef FOURCC_NVM0
#define FOURCC_NVM0                        mmioFOURCC('N','V','M','0') // auto mip mapped texture
#endif
#ifndef FOURCC_NVM1
#define FOURCC_NVM1                        mmioFOURCC('N','V','M','1')
#endif
#ifndef FOURCC_NVM2
#define FOURCC_NVM2                        mmioFOURCC('N','V','M','2')
#endif
#ifndef FOURCC_NVM3
#define FOURCC_NVM3                        mmioFOURCC('N','V','M','3')
#endif
#ifndef FOURCC_DXT1
#define FOURCC_DXT1                        mmioFOURCC('D','X','T','1') // Compressed Texture
#endif
#ifndef FOURCC_DXT2
#define FOURCC_DXT2                        mmioFOURCC('D','X','T','2')
#endif
#ifndef FOURCC_DXT3
#define FOURCC_DXT3                        mmioFOURCC('D','X','T','3')
#endif
#ifndef FOURCC_DXT4
#define FOURCC_DXT4                        mmioFOURCC('D','X','T','4')
#endif
#ifndef FOURCC_DXT5
#define FOURCC_DXT5                        mmioFOURCC('D','X','T','5')
#endif
#ifndef FOURCC_NVCS
#define FOURCC_NVCS                        mmioFOURCC('N','V','C','S')
#endif
#ifndef FOURCC_3x16
#define FOURCC_3x16                        mmioFOURCC('3','x','1','6')
#endif
#ifndef FOURCC_4x16
#define FOURCC_4x16                        mmioFOURCC('4','x','1','6')
#endif
#ifndef FOURCC_4x32
#define FOURCC_4x32                        mmioFOURCC('4','x','3','2')
#endif
#ifndef FOURCC_ATI1
#define FOURCC_ATI1                        mmioFOURCC('A','T','I','1')
#endif
#ifndef FOURCC_ATI2
#define FOURCC_ATI2                        mmioFOURCC('A','T','I','2')
#endif
#ifndef FOURCC_RAWZ
#define FOURCC_RAWZ                        mmioFOURCC('R','A','W','Z')
#endif
#ifndef FOURCC_INTZ
#define FOURCC_INTZ                        mmioFOURCC('I','N','T','Z')
#endif
// Expose this texture format if we support the improved shader sample mask for high quality multisampling.
// currently only on nv47/G70+
#ifndef FOURCC_SSAA
#define FOURCC_SSAA                        mmioFOURCC('S','S','A','A')
#endif
#ifndef FOURCC_ATOC
#define FOURCC_ATOC                        mmioFOURCC('A','T','O','C')
#endif
#ifndef FOURCC_NVDB
#define FOURCC_NVDB                        mmioFOURCC('N','V','D','B')
#endif
// This FourCC is used as a rendertarget format that has a very small memory footprint, regardless of
// its dimensions, it can be set as a color buffer when doing a Z-Only rendering for shadow maps for example.
#ifndef FOURCC_NULL
#define FOURCC_NULL                        mmioFOURCC('N','U','L','L')
#endif

#ifndef FOURCC_XRGB
#define FOURCC_XRGB     3
#endif

#ifndef FOURCC_ARGB
#define FOURCC_ARGB     4
#endif

#ifndef FOURCC_ABGR
#define FOURCC_ABGR     5
#endif

#ifndef FOURCC_ABGR10
#define FOURCC_ABGR10   6
#endif

#ifndef FOURCC_ARGB10
#define FOURCC_ARGB10   7
#endif

#ifndef FOURCC_FP16
#define FOURCC_FP16     8
#endif

// This is done on special request.needs to be tested.
#ifndef FOURCC_3x11
#define FOURCC_3x11                        mmioFOURCC('3','x','1','1')
#endif

// YUV444
#ifndef FOURCC_444P
#define FOURCC_444P                        mmioFOURCC('4','4','4','P')
#endif
// YUV444
#ifndef FOURCC_444S
#define FOURCC_444S                        mmioFOURCC('4','4','4','S')
#endif
// 10BitYUV444 Planar
#ifndef FOURCC_P410
#define FOURCC_P410                        mmioFOURCC('P','4','1','0')
#endif
// 10BitYUV444 Semiplanar
#ifndef FOURCC_S410
#define FOURCC_S410                        mmioFOURCC('S','4','1','0')
#endif

#endif // _NVFOURCC_H_
