////----------------------------------------------------------------------------------
// File:        CDx1xNGX_common.h
// SDK Version: 1.0.2
//
// SPDX-FileCopyrightText: Copyright (c) 2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
// SPDX-License-Identifier: LicenseRef-NvidiaProprietary
//
// NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
// property and proprietary rights in and to this material, related
// documentation and any modifications thereto. Any use, reproduction,
// disclosure or distribution of this material and related documentation
// without an express license agreement from NVIDIA CORPORATION or
// its affiliates is strictly prohibited.
//
//----------------------------------------------------------------------------------

///////////////////////////////////////////
// CDx1xNGX_common.h
// shared items for NGX DX11/DX12 wrapper classes

#pragma once

#if defined(NGX_CLASS_USE)
// include ngx sdk headers
#include <nvsdk_ngx_defs.h>
#include <nvsdk_ngx_defs_truehdr.h>
#include <nvsdk_ngx_helpers_truehdr.h>
#include <nvsdk_ngx_defs_vsr.h>
#include <nvsdk_ngx_helpers_vsr.h>


#define APP_ID      0
#define APP_PATH    L"."

#else
struct NVSDK_NGX_Parameter;
struct NVSDK_NGX_Handle;
#endif

#if defined(DEFINE_SAFE_TEMPLATES) || defined(NGX_CLASS_USE)
template <class T> inline void SafeRelease(T*& pT)
{
    if (pT != NULL)
    {
        pT->Release();
        pT = NULL;
    }
}

template <class T> inline void SafeCloseHandle(T*& pT)
{
    if (pT != NULL)
    {
        CloseHandle(pT);
        pT = NULL;
    }
}

template <class T> inline void SafeDelete(T*& pT)
{
    if (pT != NULL)
    {
        delete pT;
        pT = NULL;
    }
}
#endif