//----------------------------------------------------------------------------------
// File:        CDx12Sync.h
// SDK Version: 1.0.2
//
// SPDX-FileCopyrightText: Copyright (c) 2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
// SPDX-License-Identifier: LicenseRef-NvidiaProprietary
//
// NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
// property and proprietary rights in and to this material, related
// documentation and any modifications thereto. Any use, reproduction,
// disclosure or distribution of this material and related documentation
// without an express license agreement from NVIDIA CORPORATION or
// its affiliates is strictly prohibited.
//
//----------------------------------------------------------------------------------

///////////////////////////////////////////
// CDx12Sync.h
//
// Implementation of DX12 Sync Object wrapping DX12 Fence
//

#pragma once

// fences can be sequential use with one for each resource
// or multiple use with an array of fence values for each resource

class CDx12SyncObject
{
public:
    CDx12SyncObject(ID3D12Device* pD3D12Device);
    ~CDx12SyncObject();

    UINT64 SignalFence(ID3D12CommandQueue* pCmdQ);
    void WaitForFence(ID3D12CommandQueue* pCmdQ);
    void WaitForCPUFence();

    // these are for checking if an older value has finished
    void WaitForFenceValue(ID3D12CommandQueue* pCmdQ, UINT64 waitValue);
    void WaitForCPUFenceValue(UINT64 waitValue);

    // Synchronization objects.
    ID3D12Fence*                    m_fence;
    UINT64                          m_fenceSignaledValue;
};

typedef CDx12SyncObject* PCDx12SyncObject;


class CDx12SyncObjectArray
{
public:
    CDx12SyncObjectArray(ID3D12Device* pD3D12Device, UINT maxIndex);
    ~CDx12SyncObjectArray();

    UINT64 SignalFenceIndexed(ID3D12CommandQueue* pCmdQ, UINT index);
    void WaitForFenceIndexed(ID3D12CommandQueue* pCmdQ, UINT index);
    void WaitForCPUFenceIndexed(UINT index);
    CDx12SyncObject* GetFenceIndexed(UINT index);

private:
    PCDx12SyncObject*               m_aSyncObjects;
    UINT                            m_TotalIndexed;
};

