//----------------------------------------------------------------------------------
// File:        CDx12SwapChain.h
// SDK Version: 1.0.2
//
// SPDX-FileCopyrightText: Copyright (c) 2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
// SPDX-License-Identifier: LicenseRef-NvidiaProprietary
//
// NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
// property and proprietary rights in and to this material, related
// documentation and any modifications thereto. Any use, reproduction,
// disclosure or distribution of this material and related documentation
// without an express license agreement from NVIDIA CORPORATION or
// its affiliates is strictly prohibited.
//
//----------------------------------------------------------------------------------

///////////////////////////////////////////
// CDx12SwapChain.h
//
// Implementation of DX12 SwapChain wrapping a DXGI SwapChain
//

#pragma once

#include <d3d11_3.h>
#include <dxgi1_5.h>

class CDx12SwapChain
{
public:
    CDx12SwapChain();
    ~CDx12SwapChain();
    HRESULT Init(ID3D12Device*pD3D12Device, HWND hwnd, UINT WidthFS, UINT HeightFS,
                    DXGI_FORMAT dispFormat, UINT backBufferCount,
                    UINT gpuStagingMask, UINT gpuVisibleMask);

    HRESULT GetBuffer(ID3D12Resource** ppBuffer, class CDx12SyncObject** ppSyncObj);
    HRESULT Present();

    DXGI_COLOR_SPACE_TYPE  UpdateSwapChainColorSpace(CDx1xCommon* pCDx1xCommon, bool bSupportHDR);

private:
    ID3D12Device*                                   m_pD3D12Device;
    ID3D12CommandAllocator*                         m_commandAllocator;
    ID3D12GraphicsCommandList*                      m_commandList;
    ID3D12CommandQueue*                             m_commandQueue;
    IDXGISwapChain4*                                m_pSwapChain;

#ifdef __ID3D12Device4_INTERFACE_DEFINED__
    ID3D12Device4*                                  m_pD3D12Device4;
    ID3D12GraphicsCommandList3*                     m_commandList3;
    ID3D12ProtectedResourceSession*                 m_protectedResourceSession;
#endif

    UINT                                            m_NumBackBuffers;
    UINT                                            m_CurBackBufferIndex;
    RECT                                            m_rcFullScreen;

    LONGLONG                                        m_freq;
    LARGE_INTEGER                                   m_prevtime;

    HWND                                            m_hWndDisplay;
    DXGI_FORMAT                                     m_DisplayFormat;
    UINT                                            m_uWidthFS;
    UINT                                            m_uHeightFS;

    const UINT                                      m_gpuIndex;
    const UINT                                      m_gpuMask;
    UINT                                            m_gpuStagingMask;
    UINT                                            m_gpuVisibleMask;

    class CDx12SyncObjectArray*                     m_BackBufferSyncObj;
    class CDx12SyncObject*                          m_AllocatorSyncObj;

    ID3D12Resource*                                 m_StagingBuffer;
    class CDx12SyncObject*                          m_StagingSyncObj;
    CRITICAL_SECTION                                m_csStagingBuffer;

    HRESULT UpdateBackBufferFromStaging();
};

HRESULT GetAdapter(IDXGIFactory5* pFactory, IDXGIAdapter3** ppAdapter);
