//----------------------------------------------------------------------------------
// File:        CDx11Api.h
// SDK Version: 1.0.2
//
// SPDX-FileCopyrightText: Copyright (c) 2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
// SPDX-License-Identifier: LicenseRef-NvidiaProprietary
//
// NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
// property and proprietary rights in and to this material, related
// documentation and any modifications thereto. Any use, reproduction,
// disclosure or distribution of this material and related documentation
// without an express license agreement from NVIDIA CORPORATION or
// its affiliates is strictly prohibited.
//
//----------------------------------------------------------------------------------

///////////////////////////////////////////
// CDx11Api.h
//
// Top level API into DX11 video devices
//

#pragma once

#include <d3d11_4.h>
#include "CDx1x_Common.h"

class CDx11SwapChain
{
public:
    CDx11SwapChain(HWND hwnd, DXGI_FORMAT dispFormat, IDXGISwapChain4* pSwapChain)
        : m_hWndDisplay(hwnd)
        , m_DisplayFormat(dispFormat)
        , m_pSwapChain(pSwapChain)
    {}

    ~CDx11SwapChain()
    {
        SafeRelease(m_pSwapChain);
    }

    HRESULT GetBuffer(ID3D11Texture2D** ppBuffer);
    HRESULT Present();
    DXGI_COLOR_SPACE_TYPE UpdateSwapChainColorSpace(CDx1xCommon* pCDx1xCommon, bool bSupportHDR);

private:
    HWND                                            m_hWndDisplay;
    DXGI_FORMAT                                     m_DisplayFormat;
    IDXGISwapChain4*                                m_pSwapChain;
};


class CDx11Api
{
public:
    CDx11Api() {}

    HRESULT         Init(CDx1xCommon* pCDx1xCommon, HWND hWndDisplay);
    void            ShutDown();

    HRESULT         CreateVideoProcessor(DXGI_FORMAT VPOutputFormat, UINT uInWidth, UINT uInHeight, UINT uOutWidth, UINT uOutHeight);
    HRESULT         CreateSwapChain(HWND hWndDisplay, DXGI_FORMAT dispFormat, UINT uSwapWidth, UINT uSwapHeight, CDx11SwapChain** ppSwapChain);

    HRESULT         CreateTexture2D(UINT                Width,
                                    UINT                Height,
                                    DXGI_FORMAT         dxgiFormat,
                                    UINT                NumBuffers,
                                    bool                bIsHwRT,
                                    bool                bIsCPUWrite,
                                    ID3D11Texture2D**   ppTexture);

    void            SetOutputColorSpace(DXGI_COLOR_SPACE_TYPE ColorSpace);
    HRESULT         VpBltHd(ID3D11Texture2D** ppSrcSurface, ID3D11Texture2D* pDstSurface, UINT uOutWidth, UINT uOutHeight);

    ID3D11Device*   GetDevice() { return m_pD3D11Device; };
    HRESULT         MapStagingSurface(ID3D11Texture2D* pStagingSurface, D3D11_MAPPED_SUBRESOURCE* pMapped, bool bToWrite);
    HRESULT         UnMapStagingSurface(ID3D11Texture2D* pSurface, ID3D11Texture2D* pStagingSurface, bool bDoCopy, UINT uSubResource);

protected:
    ID3D11Device*                               m_pD3D11Device          = nullptr;
    ID3D11DeviceContext*                        m_pD3D11DeviceContext   = nullptr;
    ID3D11VideoDevice2*                         m_pDX11VideoDevice      = nullptr;
    ID3D11VideoContext3*                        m_pVideoContext         = nullptr;
    ID3D11VideoProcessorEnumerator*             m_pVideoProcessorEnum   = nullptr;
    ID3D11VideoProcessor*                       m_pVideoProcessor       = nullptr;
};
