////----------------------------------------------------------------------------------
// File:        TrueHDRDemoNGX.h
// SDK Version: 1.0.2
//
// SPDX-FileCopyrightText: Copyright (c) 2023-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
// SPDX-License-Identifier: LicenseRef-NvidiaProprietary
//
// NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
// property and proprietary rights in and to this material, related
// documentation and any modifications thereto. Any use, reproduction,
// disclosure or distribution of this material and related documentation
// without an express license agreement from NVIDIA CORPORATION or
// its affiliates is strictly prohibited.
//
//----------------------------------------------------------------------------------

///////////////////////////////////////////
// TrueHDRDemoNGX.h
//
// This is a desktop app the creates windows and calls the TrueHDRDemo classes
// to provide a sample of how to an app can use the NGX wrapper classes.
//

#pragma once

#include "resource.h"

// Configuation used with the TrueHDRDemo classes
struct Configuration_s
{
    bool  bFP16;
    bool  bUseNativeSize;
    UINT  DisplayWidth;
    UINT  DisplayHeight;

    UINT  WidthInUse;
    UINT  HeightInUse;
    char* pSzInputFile;
    bool  bMonitorIsNotNV;
};