//----------------------------------------------------------------------------------
// File:        CDX11TrueHDRDemo.h
// SDK Version: 1.0.2
//
// SPDX-FileCopyrightText: Copyright (c) 2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
// SPDX-License-Identifier: LicenseRef-NvidiaProprietary
//
// NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
// property and proprietary rights in and to this material, related
// documentation and any modifications thereto. Any use, reproduction,
// disclosure or distribution of this material and related documentation
// without an express license agreement from NVIDIA CORPORATION or
// its affiliates is strictly prohibited.
//
//----------------------------------------------------------------------------------

///////////////////////////////////////////
// CDX11TrueHDRDemo.h
//
// This is an example of a DX11 class using the NGX wrapper class for TrueHDR
// StreamData is used for input setup and reading from the uncompressed file
//

#pragma once


#include "CDx11Api.h"
#include "TrueHDRDemoNGX.h"
#include "CVideoFile.h"

struct CStreamData
{
    BOOL                    Enable;
    ID3D11Texture2D*        pSurface;
    ID3D11Texture2D*        pStagingSurface;

    CVideoFile*             pVideoFile;
    int                     hVideoFile;
    int                     FramesRead;
    char                    FileName[MAX_PATH];
    int                     Width;
    int                     Height;
    int                     MaxFrameCount;
    int                     CurFrameCount;

    DXGI_FORMAT             StreamFormat;

    // these are what are pass to dx11
    BOOL                                                AlphaEnable;
    FLOAT                                               Alpha;
    BOOL                                                AutoProcessingEnable;
    DXGI_COLOR_SPACE_TYPE                               ColorSpace;
    BOOL                                                DstRectEnable;
    RECT                                                DstRect;
    D3D11_VIDEO_FRAME_FORMAT                            FrameFormat;
    BOOL                                                LumaKeyEnable;
    FLOAT                                               LumaKeyLower;
    FLOAT                                               LumaKeyUpper;
    D3D11_VIDEO_PROCESSOR_OUTPUT_RATE                   OutputRate;
    BOOL                                                OutputRateRepeatFrame;
    DXGI_RATIONAL                                       OutputRateCustomRate;
    BOOL                                                PixelAspectRatioEnable;
    DXGI_RATIONAL                                       PixelAspectRatioSource;
    DXGI_RATIONAL                                       PixelAspectRatioDestination;
    BOOL                                                RotationEnable;
    D3D11_VIDEO_PROCESSOR_ROTATION                      Rotation;
    BOOL                                                SrcRectEnable;
    RECT                                                SrcRect;
};

class CDX11TrueHDRDemo
{
public:
    CDX11TrueHDRDemo() {}

    HRESULT     Init(HWND hWndDisplay, HWND hWndDisplayAlt, Configuration_s* pConfiguration);
    HRESULT     NextFrame(bool bBackward = false);
    void        Shutdown();

protected:
    class CDx11Api*                             m_pCDx11Api = nullptr;
    CDx1xCommon                                 m_CDx1xCommon = {};

    CStreamData                                 m_StreamData = {};
    UINT                                        m_InWidth = 0;
    UINT                                        m_InHeight = 0;
    UINT                                        m_OutWidth = 0;
    UINT                                        m_OutHeight = 0;
    UINT                                        m_uCurFrameCount = 0;

    CDx11SwapChain*                             m_pSwapChain = nullptr;
    CDx11SwapChain*                             m_pSwapChainAlt = nullptr;

    DXGI_FORMAT                                 m_VPOutputFormat = {};
    DXGI_FORMAT                                 m_DstFormat = {};
    DXGI_FORMAT                                 m_DstFormatAlt = {};
    DXGI_COLOR_SPACE_TYPE                       m_VPDefaultColorSpace = DXGI_COLOR_SPACE_RGB_FULL_G22_NONE_P709;

    class CDx11NGXTrueHDR*                      m_pCNGXTrueHDR      = nullptr;
    ID3D11Texture2D*                            m_pNGXInputBuffer   = nullptr;
    RECT                                        m_rcNGXInput        = {};
    RECT                                        m_rcNGXOutput       = {};

    HRESULT     CreateSurfaces();

    bool        SetupStreamData(CStreamData* pStreamData, char* szFile);
    HRESULT     FillFrameFromFile(CStreamData* pStreamData, bool bBackward);
};
