
# RTX Video SDK ReadME.txt
## Prereqs:
- NVIDIA driver R550.50 or later
- Windows 10+
- Visual Studio 2019(V142)+
- Visual Studio Build Tools C++ MFC and C++ ATL (V142)+
- Latest RTX Video SDK
- Set NV_RTX_VIDEO_SDK environment variable to RTX Video SDK location
## Generating Sample Media:
Input files can be generated using the third party ffmpeg tool. Visit https://ffmpeg.org/ for installation and usage.

Start with a standard mp4 or mov video clip. Some publicly available clips can be found here:
- https://peach.blender.org/
- https://stock.adobe.com/video

Use ffmpeg to downscale the video if needed. Use -1 on scale for same ratio (note use 704 instead of 720 for 720p)
`ffmpeg.exe -i "file.mp4" -vf scale=1280:-1 scaled1280.mp4`

ffmpeg can also limit the bitrate of the output video using the `-b:v` flag to simulate lower quality input video.

To capture the first 120 frames to NV12
`ffmpeg -i scaled1280.mp4 -c:v rawvideo -pix_fmt nv12 -start_number 0 -frames:v 120 NV12_1280_720_1280_fname.yuv`

File name must be in the form and use NV12:
`fmt_width_height_pitch_numFrames_xxxx.xxx`
For example:
`NV12_1280_720_1280_120_star_sky.yuv`
## Sample Overview:
### RTX_Video_API 
Is a sample api that simplifies using NGX features. The api is DX11 and DX12 only providing a very simple interface to use NGX VSR and THDR. 
- There are create, evaluate, shutdown functions for DX11, DX12.
- The include file rtx_video_api.h can be included in a desired project.
- The static lib RTX_Video_API.lib can be linked in a desired project.
### TrueHDRDemo 
Plays a yuv data file using NGX to apply TrueHDR. The Demo apps will loop through a video file continously.
- The top window shows the the RTX Video result.
- The lower window is a baseline without any additional effects.
- You can stop playback and single step forward or backward.
### VSRDemo 
Plays a yuv data file using NGX to apply Video Super Resolution. The Demo apps will loop through a video file continously.
- The top window shows the the RTX Video result.
- The lower window is a baseline without any additional effects.
- You can stop playback and single step forward or backward.
- You can adjust VSR quality with the numbered quality buttons.
### TrueHDR_VSR_Demo 
Plays a yuv data file using NGX to apply both TrueHDR and Video Super Resolution. The Demo apps will loop through a video file continously.
- The top window shows the the RTX Video result.
- The lower window is a baseline without any additional effects.
- You can stop playback and single step forward or backward.
## Building The Samples:
In the `samples` folder, open the `NGX_RTX_Video.sln` with VS2019 or later. Depending on what Visual Studio version installed, it may ask if you want to upgrade the project. You may do that.

Build the samples, either release or debug. The exes will be in `x64Release` or `x64Debug`. (NGX requires x64). 

Check the programming guide Troubleshooting and FAQ for common issues with building the samples.

## Running The Samples:
Generate YUV file as needed. Then, put `.exe` and the feature `.dll` (in rtx video sdk `bin\Windows\x64\dev`) into the same folder as the generated YUV file. Run the executables from command line with the following args:

### TrueHDRDemo 
```
-i <file>  // required: use <input file> name: 4cc_width_height_pitch_frames_xxxx.xxx
-dx12  // use dx12 (default dx11)
-fp16  // use fp16 output (default abgr10)
-size w h  // display at this size
-nativeSize // display at source size
-fps n  // frames per second (1-60)
-head n  // head on display adapter (default 0)
-?  // usage
```
### VSRDemo 
```
-i <file>  // required: use <input file> name: 4cc_width_height_pitch_frames_xxxx.xxx
-dx12  // use dx12 (default dx11)
-size w h  // display at this size
-nativeSize // display at source size
-fps n  // frames per second (1-60)
-head n  // head on display adapter (default 0)
-?  // usage
```
### TrueHDR_VSR_Demo 
```
-i <file>  // required: use <file> name: 4cc_width_height_pitch_frames_xxx.xxx
-vsr  // use vsr (-thdr or -vsr required)
-thdr  // use truehdr (-thdr or -vsr required)
-vsrQuality n  // vsr quality level 1 to 4 (default 1)
-thdrContrast n  // truehdr contrast 0 to 200 (default 100)
-thdrSaturation n  // truehdr saturation 0 to 200 (default 100)
-thdrMiddleGrey n  // truehdr middle grey 10 to 100 (default 50)
-thdrMaxLuminance n // truehdr monitor max luminance 400 to 2000 (default from monitor)
-head n  // head on display adapter (default 0)
-dx12  // use dx12 (default dx11)
-size w h  // display at this size
-nativeSize  // display at source size
-fps n  // frames per second (1-60)
-head n  // head on display adapter (default 0)
-?  // usage
```