#!/usr/bin/env python3

import os
import platform
import sys

from datetime import datetime
from setuptools import setup


SUPPORTED_PLATFORMS = [
    "linux",
    "win32",
]

__package_name__ = "nvidia-cublas-cu11"
__description__  = "CUBLAS native runtime libraries Metapackage"
__version__      = "2021.10.25"


if __name__ == "__main__":
    # ┍━━━━━━━━━━━━━━━━━━━━━┯━━━━━━━━━━━━━━━━━━━━━━┑
    # │ System              │ `sys.platform` Value │
    # ┝━━━━━━━━━━━━━━━━━━━━━┿━━━━━━━━━━━━━━━━━━━━━━┥
    # │ Linux               │ linux                │
    # │ Windows             │ win32                │
    # │ Windows/Cygwin      │ cygwin               │
    # │ Windows/MSYS2       │ msys                 │
    # │ Mac OS X            │ darwin               │
    # │ OS/2                │ os2                  │
    # │ OS/2 EMX            │ os2emx               │
    # │ RiscOS              │ riscos               │
    # │ AtheOS              │ atheos               │
    # │ FreeBSD 7           │ freebsd7             │
    # │ FreeBSD 8           │ freebsd8             │
    # │ FreeBSD N           │ freebsdN             │
    # │ OpenBSD 6           │ openbsd6             │
    # ┕━━━━━━━━━━━━━━━━━━━━━┷━━━━━━━━━━━━━━━━━━━━━━┙
    if sys.platform not in SUPPORTED_PLATFORMS:
        raise OSError("Your operating system is not supported by "
                      "`{_pkg}`: {_platform}.\nOnly these systems are "
                      "supported: `{_supported}`.".format(
                        _pkg=__package_name__,
                        _platform=sys.platform,
                        _supported=SUPPORTED_PLATFORMS
                      )
        )

    if platform.machine().lower() not in ["x86_64", "amd64"]:
        raise OSError("Your CPU architecture is not supported yet. Only x86_64 "
                      "on Linux and AMD64 on windows are supported. Received: "
                      "{}".format(platform.machine()))


    setup(
        name=__package_name__,
        version=__version__,
        description=__description__,
        url="https://developer.nvidia.com/cuda-zone",
        author="Nvidia CUDA Installer Team",
        author_email="cuda_installer@nvidia.com",
        license="NVIDIA Proprietary Software",
        install_requires=['nvidia-cublas-cu115'],
        include_package_data=True,
    )